#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <climits>
#include <float.h>

using namespace std;

struct Tacka
{
    long x, y;
    bool operator<(const Tacka& p) const
    {
        return (x < p.x) || (x == p.x && y < p.y);
    }
    bool operator==(const Tacka& p) const
    {
        return x==p.x && y == p.y;
    }
};

long long zaokret(const Tacka& O, const Tacka& A, const Tacka& B)
{
    long long umk = A.x - O.x;
    umk *= B.y - O.y;

    long long umc = A.y - O.y;
    umc *= B.x - O.x;

    return umk - umc;
}

// ispituje da li a->b->p formiraju desni zaokret
bool jeDesniZaokret(Tacka& a, Tacka& b, Tacka& p)
{
    return zaokret(a, b, p) < 0;
}

vector<Tacka> konvOmotac(vector<Tacka>& tacke)
{
    int n = tacke.size();
    if (n <= 1) return tacke;

    sort(tacke.begin(), tacke.end());
    vector<Tacka> omotac;

    for (int i = 0; i < n; ++i)
    {
        while (omotac.size() >= 2 && jeDesniZaokret(omotac[omotac.size() - 2], omotac[omotac.size() - 1], tacke[i]))
            omotac.pop_back();
        omotac.push_back(tacke[i]);
    }

    for (int i = n - 2, t = omotac.size() + 1; i >= 0; --i)
    {
        while (omotac.size() >= t && jeDesniZaokret(omotac[omotac.size() - 2], omotac[omotac.size() - 1], tacke[i]))
            omotac.pop_back();
        omotac.push_back(tacke[i]);
    }

    omotac.pop_back();
    return omotac;
}

long long povrsinaMnogougla(const vector<Tacka>& mnogougao)
{
    int n = mnogougao.size();
    long long povrsina = 0;
    for (int i = 0; i < n; ++i)
    {
        int j = (i + 1) % n;

        long long g = mnogougao[i].x;
        g *= mnogougao[j].y;

        long long d = mnogougao[j].x;
        d *= mnogougao[i].y;
        povrsina += g - d;
    }
    return abs(povrsina) / 2;
}

long long  povrSkoroKonvOmot(vector<Tacka>& tacke)
{
    vector<Tacka> omotacUFulu = konvOmotac(tacke);
    long long  minPovrsina = LLONG_MAX;

    /*
    cout << "Omotac u fulu "<<endl;
    for (const auto& p : omotacUFulu) {
        cout << p.x << " " << p.y << endl;
    }
    */

    for (int i = 0; i < omotacUFulu.size(); ++i)
    {
        vector<Tacka> bezTacke = tacke;
        auto it = find(bezTacke.begin(), bezTacke.end(), omotacUFulu[i]);
        bezTacke.erase(it);

        vector<Tacka> skoroOmotac = konvOmotac(bezTacke);
        long long povrsina = povrsinaMnogougla(skoroOmotac);
        if (povrsina < minPovrsina)
        {
            minPovrsina = povrsina;
        }
    }

    return minPovrsina;
}

int main()
{
    int n;
    scanf("%d",&n);

    vector<Tacka> tacke(n);
    for (int i = 0; i < n; ++i)
    {
        scanf("%ld%ld",&tacke[i].x,&tacke[i].y);
    }

    printf("%lld",povrSkoroKonvOmot(tacke));

    return 0;
}